#version 330
#extension GL_EXT_gpu_shader4 : enable
//Swinning PendulumsMod01.fsh  by n1kk
//https://www.shadertoy.com/view/4tKSRV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float getLineThickness(float thickness) {
    // thickness optimized for resolution
    return thickness * 400. / max(iResolution.x, iResolution.y); 
}

float circle(vec2 origin, vec2 pos, float radius)
{
    float n = 100.0 / getLineThickness(1.0);
    return clamp(((1.0-abs(length(origin + pos)-radius))-(1.0 - 1.0/n)) * n, 0.0, 1.0);
}

float circleFill(vec2 origin, vec2 pos, float radius)
{
    return clamp(((1.0-(length(origin+pos)-radius))-0.99)*150.0, 0.0, 1.0);   
}

float circleGlow(vec2 origin, vec2 pos, float radius, float len, float str)
{
    float inCircle = ((1.0-(length(origin + pos)-(radius + len)))-0.99) * str;
    return clamp(inCircle, 0.0, 1.0);   
}


// courtesy of Inigo Quilez
float line( in vec2 p, in vec2 a, in vec2 b )
{
    vec2 pa = -p - a;
    vec2 ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    float d = length( pa - ba*h );
    //return clamp(((1.0 - d)-0.99)* 100.0 , 0.0, 1.0);
	float n = 100.0 / getLineThickness(1.5);
    return clamp(((1.0 - d) - (1.0 - 1.0/n)) * n , 0.0, 1.0);
}

float lineGlow(in vec2 p, in vec2 a, in vec2 b, float str )
{
    vec2 pa = -p - a;
    vec2 ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    float d = length( pa - ba*h );
    float n = 10.0;
    return 0.1 * str * clamp(((1.0 - d) - (1.0 - 1.0/n)) * n , 0.0, 1.0);
}

vec2 pointOnACircle(vec2 pos, float r, float a) {
 	return vec2(pos.x + r * sin(a),  pos.y + r * cos(a));
}

//////////////////////////////////////////////
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    // origin
    vec2 p = -1.0 + 2.0 * uv;
    p.x *= iResolution.x / iResolution.y;
    
    vec3 colour = vec3(0);
    vec3 white = vec3(1);
    
    vec3 c = vec3(0);
    
    #define SWING_RADIUS 1.7
    #define SWING_ANGLE 0.1
    #define SWING_SPEED 5.5
    #define PHASE_SHIFT_RATE 0.015
    
    #define SHIFT_X 0.0
    #define SHIFT_Y -0.85
    
    #define BALL_COUNT 18.0
    #define BALL_SIZE 0.045
    #define BALL_GLOW_SIZE 0.20  //0.4
    #define BALL_GLOW_STR 0.06  //0.09
   	
    #define STRING_ALPHA 0.3
    #define STRING_GLOW 0.25
    #define SWING_ALPHA 0.05
    
    #define STRING_COLOR 0.8*vec3(1.0, 0.85, 0.0)
    #define BALL_COLOR vec3(0.80, 0.40, 0.80)

    #define START_FRAME_SHIFT 18.78

    
    for(float i = 1.0; i <= BALL_COUNT; i++) {
    	vec2 fixed_point = vec2(SHIFT_X, -SWING_RADIUS + SHIFT_Y);
        float curr_phase = 1.0 - i * PHASE_SHIFT_RATE;
        float ang_vel = cos(SWING_SPEED * (iTime + START_FRAME_SHIFT) * curr_phase);
        float curr_raduis = SWING_RADIUS + i * 0.09;
        float curr_swing = SWING_ANGLE  * ang_vel;
        float curr_ball_radius = BALL_SIZE + i * 0.001;
        vec2 ball_pos = pointOnACircle(fixed_point, curr_raduis, curr_swing);
        //curr_ball_radius = curr_ball_radius + curr_ball_radius * (ang_vel > 0. ? 1. : -1.) * 0.1;
        // ball
        c += circleFill(p, ball_pos, curr_ball_radius);// * BALL_COLOR;        
        c += circleGlow(p, ball_pos, curr_ball_radius, BALL_GLOW_SIZE, BALL_GLOW_STR);
        // string
        c += line(p, fixed_point, ball_pos) * STRING_ALPHA * STRING_COLOR;
        c += lineGlow(p, fixed_point, ball_pos, STRING_GLOW) * STRING_COLOR;
        // curve
        c += circle(p, fixed_point, curr_raduis) * SWING_ALPHA;
    }
    
    c = clamp(c, 0.0, 1.0);
   	colour = BALL_COLOR * c;
    gl_FragColor = vec4(colour, 1.0);
    gl_FragColor.a = length(gl_FragColor.rgb);
}

